/*******************************************************************************
This code replicates Figure ## Transmision of FED Hikes: The Role of Balance Sheet 
FX Vulnerabilities with Global Controls (GK Surprises), alternative specification

For confidentiality issues, we can't provide UIP nor FX debt data. Hence, we provide 
the code even it can't be run. We provide the LPs results in excel files.
*******************************************************************************/

clear
set more off
cls
clear matrix
clear mata 
set maxvar 8000
set graphics on
//Change this directory depending who is running the code
cap cd "Replication_pkg/Data"

use "LP_data", clear

/*******************************************************************************
Check units
*******************************************************************************/
replace i_treasury_12m_avg_US=i_treasury_12m_avg_US/100
/*******************************************************************************
Generate groups
*******************************************************************************/
//Updated ER classification
drop if IRR_coarse==1
drop if IRR_coarse==6

/*******************************************************************************
Drop LICS+ 
*******************************************************************************/
drop if IMF_incomeLevel==3
drop if Name=="Bolivia"
drop if Name=="Cambodia"
drop if Name=="Dominican Republic"
drop if Name=="Jamaica"
drop if Name=="Mongolia"
drop if Name=="Nicaragua"

/*******************************************************************************
Global factors 
*******************************************************************************/
//Global dollar shock as in 0Z (2022): 10% size shock 
xtset IFS_code time_q 
g Dollar_shock=ln(aeusd_g)-ln(l.aeusd_g)
replace Dollar_shock=Dollar_shock/0.1 
//Trade balance:
bys time_q EM: egen median_tb=median(trade_balance_GDP)
//Commodity index 
g l_oil=ln(oil_index)
/*******************************************************************************
Set parameters of LP
*******************************************************************************/
global lags=4 
global horizon=10 
global conf=90 //confidence levels 
global cinorm = invnormal($conf/100)
global instrument "ff4"

/*
Get RHS:
1. Lags of dependent variable 
2. Lags of gdp growth and inflation differentials 
3. Lags of the shockvar 
4. Lags of the instrument
*/
xtset IFS_code time_q 
g lcpi=ln(cpi_IFS)
g inflationIFS=D.lcpi //inflation q to q 

//winsor inflation:
winsor2 inflationIFS, replace cuts(4 96)

g lgdp=ln(rGDPsa_weo)

foreach var of varlist g_gdp_final inflationIFS {
	g double var1=`var' if IFS_code==111
	bys time_q: egen double max=max(var1) 
	g double `var'_diff=`var'-max 
	drop var1 max 
	}

xtset IFS_code time_q 
//Lags 
foreach var of varlist lgdp g_gdp_final_diff inflationIFS_diff i_treasury_12m_avg_US /*ln_theta_12m_treasury*/ i_policy_US $instrument { 
	forv l=1/$lags { 
		g `var'_l`l'=l`l'.`var'

	}
}
/*
Get the LHS: 
*/	
//Leads 
foreach var of varlist lgdp /*ln_theta_12m_treasury*/ i_policy_US{ 
	forv h=0/$horizon{ 
		g `var'_`h'=f`h'.`var'
		
	}	
}

// Time span: 
keep if time_q>=tq(1990q1) 

/*******************************************************************************
LP IV regression
*******************************************************************************/
cd "../../Figures/Figure A5"

//keep FX debt countries only! 
keep if fx_sample==1
xtset IFS_code time_q 
g l1_fx=l1.DL_GDP
global int "l1_fx"
sum $int , d 
global min=r(p25) //Replace by p25
global max=r(p75) //Replace by p75 
global colorHigh  "blue"
global colorLow  "red"

/*
Obtain coefficient to normalize 
*/
global x "*g_gdp_final_diff_l* *inflationIFS_diff_l* *i_treasury_12m_avg_US_l* ${instrument}_l* l1_fx Dollar_shock median_tb l_oil" //Define main controls

ivreghdfe i_policy_US_0 i_policy_US_l1-i_policy_US_l4 $x (i_treasury_12m_avg_US=${instrument}), absorb(IFS_code) /*first bw(`neweylag') level(90)*/
global b_norm=_b[i_treasury_12m_avg_US]


/*
GDP levels
*/
mat drop _all
mat coef=J($horizon+1,5,.)
mat coefAE=J($horizon+1,5,.)
cap n drop ub lb Quarter coef Zero EM_d
local j=1 
forv h=0/$horizon{
	local neweylag=`h'+1


	ivreghdfe lgdp_`h' *lgdp_l* $x ///
	(i_treasury_12m_avg_US c.${int}#c.i_treasury_12m_avg_US=${instrument} c.${int}#c.${instrument}), absorb(IFS_code) first bw(`neweylag') level(90)
	
	margins, dydx(i_treasury_12m_avg_US) at(${int}=($min $max)) level(90) force post
	mat B=e(b) //1X2 matrix. Element (1,1) is the marginal effect at max/min 
	mat V=e(V) //2x2 matrix. We need the elements of the diagonal
	//Low
	mat coef[`j',1]=`h' 
	mat coef[`j',2]=1
	mat coef[`j',3]=B[1,1]/${b_norm}
	mat coef[`j',4]=(B[1,1]+${cinorm}*V[1,1]^(1/2))/${b_norm} 
	mat coef[`j',5]=(B[1,1]-${cinorm}*V[1,1]^(1/2))/${b_norm} 
	
	//High
	mat coefAE[`j',1]=`h' 
	mat coefAE[`j',2]=0
	mat coefAE[`j',3]=B[1,2]/${b_norm}/${b_norm}
	mat coefAE[`j',4]=(B[1,2]+${cinorm}*V[2,2]^(1/2))/${b_norm}
	mat coefAE[`j',5]=(B[1,2]-${cinorm}*V[2,2]^(1/2))/${b_norm}
		
	local j=`j'+1
	
}
mat colnames coef="Quarter" "EM_d" "coef" "ub" "lb"
mat colnames coefAE="Quarter" "EM_d" "coef" "ub" "lb"
mat li coef
svmat coef, names(col)
g Zero=0
drop if Quarter==0
set autotabgraphs on 
twoway (line ub Quarter, lcolor("$colorHigh") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorHigh") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorHigh") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:Low FX debt}", size(huge)) xlabel(1(2)10, nogrid  tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("% change", orientation(vertical) size(large)) ///
graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) name(lgdp_EM,replace)
graph save "lgdpLow.gph", replace

cap n drop Quarter EM_d coef ub lb Zero

svmat coefAE, names(col)
g Zero=0
drop if Quarter==0

twoway (line ub Quarter, lcolor("$colorLow") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorLow") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorLow") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf: High FX debt}", size(huge)) xlabel(1(2)10, nogrid tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("% change", orientation(vertical) size(large)) ///
graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) 
graph save "lgdpHigh.gph", replace
graph combine "lgdpLow.gph" "lgdpHigh.gph", cols(2) title("{bf:GDP}", size(vlarge))  ycom
graph export "lGDP.pdf", replace
rm "lgdpLow.gph"
rm "lgdpHigh.gph"

cap n drop Quarter EM_d coef ub lb Zero
//Save results to excel 
mat A=(coef\coefAE)
svmat A,names(col)
drop if Quarter==0 
export excel Quarter EM_d coef ub lb using "Figure A5.xlsx", sheet("GDP", replace) firstrow(variables)
cap n drop Quarter EM_d coef ub lb

/*
/*
12m UIP deviation in treasury 
*/
mat drop _all
mat coef=J($horizon+1,5,.)
mat coefAE=J($horizon+1,5,.)
cap n drop ub lb Quarter coef Zero EM_d
local j=1 
forv h=0/$horizon{
	local neweylag=`h'+1
	
	
	//EM 
	ivreghdfe ln_theta_12m_treasury_`h' *ln_theta_12m_treasury_l* $x ///
	(i_treasury_12m_avg_US c.${int}#c.i_treasury_12m_avg_US=${instrument} c.${int}#c.${instrument}), absorb(IFS_code) first bw(`neweylag') level(90)
	
	margins, dydx(i_treasury_12m_avg_US) at(${int}=($min $max)) level(90) force post
	mat B=e(b) //1X2 matrix. Element (1,1) is the marginal effect at max/min 
	mat V=e(V) //2x2 matrix. We need the elements of the diagonal
	//Low
	mat coef[`j',1]=`h' 
	mat coef[`j',2]=1
	mat coef[`j',3]=B[1,1]/${b_norm}
	mat coef[`j',4]=(B[1,1]+${cinorm}*V[1,1]^(1/2))/${b_norm} 
	mat coef[`j',5]=(B[1,1]-${cinorm}*V[1,1]^(1/2))/${b_norm} 
	
	//High
	mat coefAE[`j',1]=`h' 
	mat coefAE[`j',2]=0
	mat coefAE[`j',3]=B[1,2]/${b_norm}/${b_norm}
	mat coefAE[`j',4]=(B[1,2]+${cinorm}*V[2,2]^(1/2))/${b_norm}
	mat coefAE[`j',5]=(B[1,2]-${cinorm}*V[2,2]^(1/2))/${b_norm}
		
	local j=`j'+1
	
}
mat colnames coef="Quarter" "EM_d" "coef" "ub" "lb"
mat colnames coefAE="Quarter" "EM_d" "coef" "ub" "lb"
mat li coef

svmat coef, names(col)
g Zero=0
drop if Quarter==0
set autotabgraphs on 
twoway (line ub Quarter, lcolor("$colorHigh") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorHigh") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorHigh") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:Low FX debt}", size(huge)) xlabel(1(2)10, nogrid tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("p.p. change", size(large)) ///
 graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) 
graph save "uipLow.gph", replace 
cap n drop Quarter EM_d coef ub lb Zero

svmat coefAE, names(col)
g Zero=0
drop if Quarter==0

twoway (line ub Quarter, lcolor("$colorLow") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorLow") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorLow") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf: High FX debt}", size(huge)) xlabel(1(2)10, nogrid tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("p.p. change", size(large)) ///
 graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) 
graph save "uipHigh.gph", replace 

graph combine "uipLow.gph" "uipHigh.gph", title("{bf:12m UIP deviation}", size(vlarge))  ycom
graph export "UIP.pdf", replace
rm "uipLow.gph"
rm "uipHigh.gph"

cap n drop Quarter EM_d coef ub lb Zero
//Save results to excel 
mat A=(coef\coefAE)
svmat A,names(col)
drop if Quarter==0 
export excel Quarter EM_d coef ub lb using "Figure A5.xlsx", sheet("UIP", replace) firstrow(variables)
cap n drop Quarter EM_d coef ub lb
*/
